#pragma once

#include <hash_map>

namespace DSLib
{
	class LazyWindow
	{
	public:
		typedef LRESULT (CALLBACK *MSGPROC)(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam, intptr_t userData);

		static HINSTANCE hInstance;

		static bool Initialize();
		static void Uninitialize();

		static void MessageLoop(MSG& msg);
		static bool MessagePump(MSG& msg);
		static bool MessageLoop(MSG& msg, DWORD nCount, const HANDLE* pHandles, DWORD dwMilliseconds, DWORD dwWaitMask, DWORD& res);
		static bool MessageLoop(MSG& msg, DWORD nCount, const HANDLE* pHandles, DWORD dwMilliseconds, DWORD& res)
		{
			return MessageLoop(msg, nCount, pHandles, dwMilliseconds, QS_ALLEVENTS, res);
		}

		static bool MessageLoop(MSG& msg, DWORD nCount, const HANDLE* pHandles, DWORD& res)
		{
			return MessageLoop(msg, nCount, pHandles, INFINITE, QS_ALLEVENTS, res);
		}

		static HWND CreateMessageOnlyWindow(MSGPROC msgProc, intptr_t userData);
		static HWND CreateUserWindow(int x, int y, int w, int h, HWND parent, const std::tstring& title, DWORD dwStyle = WS_OVERLAPPEDWINDOW, DWORD dwExStyle = 0, MSGPROC msgProc = NULL, intptr_t userData = 0);
		static HWND CreateUserWindow(int x, int y, int w, int h, HWND parent = NULL, DWORD dwStyle = WS_OVERLAPPEDWINDOW, DWORD dwExStyle = 0, MSGPROC msgProc = NULL, intptr_t userData = 0)
		{
			return CreateUserWindow(x, y, w, h, parent, _T(""), dwStyle, dwExStyle, msgProc, userData);
		}

		static HWND CreateUserWindow(MSGPROC msgProc = NULL, intptr_t userData = 0)
		{
			return CreateUserWindow(CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, WS_OVERLAPPEDWINDOW, 0, msgProc, userData);
		}

		static void DestroyUserWindow(HWND& hWnd)
		{
			if(hWnd)
			{
				DestroyWindow(hWnd);
				hWnd = NULL;
			}
		}

	protected:
		static LRESULT CALLBACK WindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
	};

#define LAZYWINDOW_DECL_MSGPROC(T, name) \
	static LRESULT CALLBACK _ ## name ## _MsgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, intptr_t userData) \
	{ T* pThis = (T*)userData; return pThis->name ## _MsgProc(hWnd, uMsg, wParam, lParam); } \
	LRESULT name ## _MsgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)

	class Window
	{
	public:
		std::tstring title;
		int x;
		int y;
		int width;
		int height;
		HWND parent;
		DWORD style;
		DWORD exStyle;
		
		explicit Window();
		virtual ~Window();

		operator HWND() const
		{
			return mWnd;
		}

		void Create();
		void Destroy();

	protected:
		HWND mWnd;

		virtual bool OnMessage(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam, LRESULT& lResult);

		LAZYWINDOW_DECL_MSGPROC(Window, Default);		
	};

	struct CommandRequest 
	{
		HANDLE completeNotify;

		explicit CommandRequest(HANDLE evt = NULL);
		virtual ~CommandRequest();
	};

	class Service
	{
	public:
		explicit Service(void);
		virtual ~Service(void);

		void Create();
		void Destroy();

		void PostCommand(UINT cmd, CommandRequest* req = NULL);
		void SendCommand(UINT cmd, CommandRequest* req = NULL);

		const HANDLE& GetThread() const
		{
			return mThread;
		}

		const DWORD& GetThreadID() const
		{
			return mThreadId;
		}

	protected:
		DWORD mThreadId;
		HANDLE mThread;
		HWND mMessageWindow;
		HANDLE mThreadReady;
		MSG mCurrentMessage;

		static void PostMessageGuaranteed(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

		static DWORD WINAPI _ThreadProc(LPVOID lpParameter);
		DWORD ThreadProc();

		static LRESULT CALLBACK _MsgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam, intptr_t userData);
		LRESULT MsgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

		virtual void OnStart();
		virtual void OnStop();
		virtual void OnCreate();
		virtual void OnDestroy();
		virtual void MessageLoop();
		virtual LRESULT OnCommand(UINT cmd, CommandRequest* req) = 0;
	};

}